
function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self) 
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    
    if not self.loaded then
      self.attLooper = 1
      self.sAttActive = true
      self.lAttActive = true
      self.attackLimit = 660 / Citadels.GetPlayer(0):GetDifficultyCoef()
      self.attackTimer = self.attackLimit
    end
        
    self.attST:LinkToTarget("stAtt")
	  self.attLT:LinkToTarget("ltAtt")
  end
  
  self.td = Timer:GetTimeDiff()
  self.attackTimer = self.attackTimer - self.td
        
  if self.attackTimer <= 0 then
    self.attackLimit = self.attackLimit * 0.95
    self.attackTimer = self.attackLimit
    HandleAttacks(self)
  end  
end

function OnTrigger(self, source, target)
  if target == "sAttackDeact" then
	  self.sAttActive = false
  elseif target == "lAttackDeact" then
    self.lAttActive = false
  end
end

function HandleAttacks(self)
  if self.lAttActive and self.attLooper == 1 then
    self.attLT:TriggerAllTargets()
    self.attLooper = 2
  elseif self.sAttActive and self.attLooper == 2 then
    self.attST:TriggerAllTargets()
    self.attLooper = 1
  else
  	self.attLooper = 0
	  self.attackTimer = 0
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.attLooper = ar:Read()
    self.sAttActive = ar:Read()
    self.lAttActive = ar:Read()
    self.attackLimit = ar:Read()
    self.attackTimer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.attLooper)
    ar:Write(self.sAttActive)
    ar:Write(self.lAttActive)
    ar:Write(self.attackLimit)
    ar:Write(self.attackTimer)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("sAttackDeact")
  self:AddTriggerTarget("lAttackDeact")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("attST")
  self:AddTriggerSource("attLT")
end
